/**
* \file: WaylandPointerListener.h
*
* \version: 0.3
*
* \release: $Name:$
*
* Handles pointer events coming from Wayland
*
* \component: Unified SPI
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USPI_WL_POINTER_LISTENER_H
#define USPI_WL_POINTER_LISTENER_H

#include <wayland-client-protocol.h>

namespace adit { namespace uspi {

class ITouchFacadeCallbacks;

/** @class  WaylandPointerListener
 *  @brief  Listener to catch the pointer events from Wayland
 */
class WaylandPointerListener
{
public:
    static wl_pointer_listener mWlPointerListener;

    WaylandPointerListener(ITouchFacadeCallbacks& inCallbacks, int inDisplayWidth, int inDisplayHeight);
    virtual ~WaylandPointerListener();

    void setLateResolution(int inWidth, int inHeight);

private:
    ITouchFacadeCallbacks& mCallbacks;

    float mXRelative;
    float mYRelative;

    // todo mDisplayWidth/Height will be asked within the event handlers
    uint16_t mDisplayWidth;
    uint16_t mDisplayHeight;
    uint8_t mButtons;

    /* Wayland pointer event handlers */
    static void onEnter(void* inMe, wl_pointer* inPointer, uint32_t inEventSerial, wl_surface* inWlSurface,
            wl_fixed_t inPixelX, wl_fixed_t inPixelY);

    static void onLeave(void* inMe, wl_pointer* inPointer, uint32_t inEventSerial, wl_surface* inWlSurface);

    static void onMotion(void* inMe, wl_pointer* inPointer, uint32_t inTimestamp, wl_fixed_t inPixelX,
            wl_fixed_t inPixelY);

    static void onButton(void* inMe, wl_pointer* inPointer, uint32_t inEventSerial, uint32_t inTimestamp,
            uint32_t inButton, uint32_t inButtonState);

    static void onAxis(void* inMe, wl_pointer* inPointer, uint32_t inTimestamp, uint32_t inAxis, wl_fixed_t inValue);

    static void onFrame(void* inMe, wl_pointer* inPointer);

    static void onAxisSource(void* inMe, wl_pointer* inPointer, uint32_t inAxisSource);

    static void onAxisStop(void* inMe, wl_pointer* inPointer, uint32_t inTimestamp, uint32_t inAxis);

    static void onAxisDiscrete(void* inMe, wl_pointer* inPointer, uint32_t inAxis, int32_t inDiscrete);
};

} } /* namespace adit { namespace uspi { */

#endif /* USPI_WL_POINTER_LISTENER_H */
